function Result = var_varce(raster, params)

% Inputs:
% raster: 1x1 cell: the timing of spikes as array in n trials with 0
%             as the stim onset
% params: struct with following att.s:
%         t_start:   time of start of recording in ms
%         t_end:     time of end of recording in ms
%         bin_width: bin width in ms
%         slide:     sliding window length in ms

% Citations: Saleh F, Fakharian M & Ghazizadeh A "Stimulus presentation can enhance spiking irregularity across subcortical and cortical regions." 2021
% A. K. Churchland, et al., Variance as a Signature of Neural Computations during Decision Making. Neuron 69, 818?831 (2011)

raster = reshape(raster(:,1),size(raster,1),1);

raster(cellfun(@(C) any(isinf(C)),raster)) = [];

% params
t_start = params.t_start;
t_end = params.t_end;
bin_width = params.bin_width;
slide = params.slide;

% finding times
Result.times = t_start+(bin_width/2):slide:t_end-(bin_width/2);

i_max = (bin_width/slide) - 1;

fano_all = [];
for i = 0:i_max
    perccount(i,i_max)
    
    times = t_start+(bin_width/2)+i*slide:bin_width:t_end-(bin_width/2);

    mat_cell = cellfun(@(x) histcounts(x,...
        (times(1) - bin_width/2):bin_width:...
        (times(end) + bin_width/2+2)),raster,'UniformOutput',false);
    mat = cell2mat(mat_cell)';
    fano_all = [fano_all; nanvar(mat,0,2) ./ nanmean(mat,2)];
end
params.conditional_FF = min(fano_all(:));

for i = 0:i_max
    
    perccount(i,i_max)
    
    times = t_start+(bin_width/2)+i*slide:bin_width:t_end-(bin_width/2);
    
    VarCE = VarCE_method(raster,times,params);
    
    Result.VEC.VarCE(ismember(Result.times, times)) = ...
        VarCE.pre_church_varce;
    Result.nSI.VarCE(ismember(Result.times, times)) = ...
        VarCE.pre_church_varce_phi;
    
    Result.VEC.VarCE_SE(ismember(Result.times, times)) = ...
        VarCE.pre_church_varce_std;

end
